#################################################################################
#                                                                               #
#    Language Sort Script                                                       #
#                                                                               #
#################################################################################
# Copyright 2020 Kai Masemann                                                   #
#################################################################################
# This file is part of Lonnox CUT                                               #
#                                                                               #
#   Lonnox CUT is free software: you can redistribute it and/or modify          #
#   it under the terms of the GNU General Public License as published by        #
#   the Free Software Foundation, either version 3 of the License, or           #
#   (at your option) any later version.                                         #
#                                                                               #
#   Lonnox CUT is distributed in the hope that it will be useful,               #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of              #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
#   GNU General Public License for more details.                                #
#                                                                               #
#   You should have received a copy of the GNU General Public License           #
#   along with Lonnox CUT.  If not, see <http://www.gnu.org/licenses/>.         #
#                                                                               #
#################################################################################

#---libraries for the layout---
import os
import imp
import sys

#---File And Dirnames---
if getattr(sys, 'frozen', False):
    # frozen
    path = os.path.dirname(sys.executable)
else:
    # unfrozen
    path = os.path.dirname(os.path.realpath(__file__))
homePath = os.path.expanduser("~")


sys.path.insert(0, path + "/lang/")
files = os.listdir(path + "/lang/")

#---Find *.py Files In Search Result And Import Them---
for file in files:
    if file.endswith(".py") and (file != "sortLang.py"):
        file = file.split(".")[0]
        __import__( file )
        ref = sys.modules[ file ]
        print("#---",file,"--------------------------------------------") 
        print("language = {")   
        for key, value in sorted(ref.language.items()):
            print( "   ", repr(key.strip()), ":", repr(value.strip()), "," )
        print("    }\n\n")


