#################################################################################
#                                                                               #
#    Windows Build Script                                                       #
#                                                                               #
#################################################################################
# Copyright 2022 Kai Masemann                                                   #
#################################################################################
# This file is part of Lonnox CUT                                               #
#                                                                               #
#   Lonnox CUT is free software: you can redistribute it and/or modify          #
#   it under the terms of the GNU General Public License as published by        #
#   the Free Software Foundation, either version 3 of the License, or           #
#   (at your option) any later version.                                         #
#                                                                               #
#   Lonnox CUT is distributed in the hope that it will be useful,               #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of              #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
#   GNU General Public License for more details.                                #
#                                                                               #
#   You should have received a copy of the GNU General Public License           #
#   along with Lonnox CUT.  If not, see <http://www.gnu.org/licenses/>.         #
#                                                                               #
#################################################################################

# c:\Python311\python.exe "Y:\Lonnox\Projekte\Lonnox CUT\Software\LonnoxCUT\setupWIN.py" build
#
# HOW TO INCLUDE LIBS-----------------------------------------------------------------------------------
# 1. Start with "includefiles = [path+'data/']" and "packages = ['cProfile']"
# 2. Try to compile your software and execute in cmd.exe to see errors
# 3. If there are any import error of a library browse to pathLib and add the library to 
#    includefiles. For example: includefiles = [ path+'data/',pathLib+'pywinusb/' ]
#    If the library can't be found in the pathLib path, then add the missing library to
#    packages. For example: packages = ['cProfile']
# 4. repeat step 2
# 5. To save SPACE add the "includefiles"-Libraries to the "excludes"-Libraries
#-------------------------------------------------------------------------------------------------------
# ADDITIONAL INOFS
# - The full icon path must not have special characters in it like ä,ö,ü.
# - python36.dll, vcruntime140.dll and python3.dll not copied while compiled 
#   on Win10 and causes the "Fail to load dll" at import PyQt5 line
#-------------------------------------------------------------------------------------------------------
# LIMIT INSTALLER SIZE
# - every library from the c:\python311\lib\ folder is copied to the installer files regardless
#   if they are needed
# - to limit installer size folders of libs that are not needed have to be inserted to the "excludes" 
#   list
#-------------------------------------------------------------------------------------------------------

import sys
import os
from cx_Freeze import setup,Executable

path = os.path.dirname(os.path.realpath(__file__)) + "/"
iconPath = path+'data/favicon.ico'
pathLib = "c:/python311/Lib/site-packages/"
pathPy = os.path.dirname(sys.executable) + "/"

'''
#---Delete Unwanted Files (Prevent Magic Numeber Error)---
# This deletes pyc files in C\:Python\ especially in the lib folder.
# The process must only be done once if a python version has changed.
count = 0
dir = pathPy
for dp, dnames, fnames in os.walk( dir ):
    for fn in fnames:
        if fn.endswith(".pyc"): 
            print("walk",dp +"/"+ fn)
            os.remove(dp+"/"+fn)
            count += 1
        
print(count, " Cache Files removed")
'''

includefiles = [ pathPy+'python3.dll',
                 pathPy+'python311.dll',  
                 pathPy+'vcruntime140.dll', 
                 pathPy+'vcruntime140_1.dll', 
                 path+'license.txt', 
                 path+'tools.csv',
                 path+'convert.py',
                 path+'module/',
                 path+'fonts/',
                 path+'lang/',
                 path+'data/']
includes = []
zip_includes = []
excludes = ['tkinter','PyQt6','numpy','PIL']
packages = ['cProfile','gcode','uni','vecFont','geomdl']

base = None
if sys.platform == "win32":
    base = "Win32GUI"

setup(
    name = 'Lonnox CUT',
    version = '4.0.0.0',
    description = 'GCode Editor',
    author = 'Kai Masemann',
    author_email = 'info@Lonnox.de',
    options = {'build_exe': {'excludes':excludes,
                             'packages':packages,
                             'zip_includes':zip_includes,
                             'include_files':includefiles}}, 
    executables = [Executable( path+'LCUT.py',base=base, icon=iconPath)]
)