'''
#################################################################################
#                                                                               #
#    Lonnox CUT - module SplineEnd                                             #
#                                                                               #
#################################################################################
#	C O N T E N T                                  								#
#-------------------------------------------------------------------------------#
#                                                                               #
#    00.00 load libraries                                                       #
#                                                                               #
#    01.00 gloabl variables                                                     #
#                                                                               #
#    02.00 g-code generator                                                     #
#        02.01 local vars                                                       #
#        02.02 change values by options                                         #
#        02.03 calculate cutpath and open/close options                         #
#        02.04 calculate tangential roundings                                   #
#        02.05 create list for forth and back direction                         #
#        02.06 add colsed contour position                                      #
#        02.07 startcodes                                                       #
#        02.08 g-code generation for module                                     #
#        02.09 end codes                                                        #
#                                                                               #
#    03.00 determine start-/endtool                                             #
#                                                                               #
#################################################################################
'''
__version__ = '1.0'
__license__ = "license.txt"
__author__ = 'Kai Masemann <info@lonnox.de>'

#################################################################################
#                                                                               #
#    00.00 load libraries                                                       #
#                                                                               #
#################################################################################

#---libraries for the layout---
import math
import os
import sys
import gcode
import uni


#################################################################################
#                                                                               #
#    01.00 gloabl variables                                                     #
#                                                                               #
#################################################################################

#---choose/ add section in the module tree---
section    = "Mill 2D"

#---name of the module in the tree---
name       = "Spline-End"
groupEnd   = ""
 
#---explain picture of the module--- 
picture    = "SplineE.png"

#---explaining text for helpbutton in lonnox cut---
info = "SplineEInfo"

#---predefined tools---
predefinedTools = False

#---widgets that are displayed to set the parameters---
# T=Text, N=NumberValues, O=OptionList, F=FileButton, C=CheckBox
widget = ("T","T")

#---parameter of the module---
labels    = ("","")

#---option presets for listed parameters---
options   = {}



class module( object ):
    #############################################################################
    #                                                                           #
    #    02.00 g-code generator                                                 #
    #                                                                           #
    #############################################################################
    def gcode( self, jTools, joblist, jIndex, preview=0 ):
        L = uni.language 

        #########################################################################
        #    02.01 local vars                                                   #
        #########################################################################
        
        #---variable values---
        code          = "\n("+ L["Spline-End"]+")\n\n"

        return code 
   

   
    #############################################################################
    #                                                                           #
    #    03.00 determine start-/endtool                                         #
    #                                                                           #
    #############################################################################
    # function returns start/endtool of THIS module for toolOptimizer 
    # "" will be ignored by optimizer 
    # "nT" will force to load no Tool
    def tool( self, joblist, jIndex ):
        
        return ("","") #(Start, Endtool)

