'''
#################################################################################
#                                                                               #
#    Lonnox CUT - module coordinate system                                      #
#                                                                               #
#################################################################################
#	C O N T E N T                                  								#
#-------------------------------------------------------------------------------#
#                                                                               #
#    00.00 load libraries                                                       #
#                                                                               #
#    01.00 gloabl variables                                                     #
#                                                                               #
#    02.00 g-code generator                                                     #
#        02.01 local vars                                                       #
#        02.02 mirror module on x-axis                                          #
#        02.03 startcodes                                                       #
#        02.04 g-code generation for module                                     #
#        02.05 end codes                                                        #
#                                                                               #
#    03.00 determine start-/endtool                                             #
#                                                                               #
#################################################################################
'''
__version__ = '1.0'
__license__ = "license.txt"
__author__ = 'Kai Masemann <info@lonnox.de>'

#################################################################################
#                                                                               #
#    00.00 load libraries                                                       #
#                                                                               #
#################################################################################

#---libraries for the layout---
import math
import os
import sys
import gcode
import uni


#################################################################################
#                                                                               #
#    01.00 gloabl variables                                                     #
#                                                                               #
#################################################################################

#---choose/ add section in the module tree---
section    = "General"

#---name of the module in the tree---
name       = "Coordinate system"
groupEnd   = ""

#---explain picture of the module--- 
picture    = "CoordinateSystem.png"

#---explaining text for helpbutton in lonnox cut---
info = "CoordSysInfo"

#---predefined tools---
predefinedTools = False

#---widgets that are displayed to set the parameters---
# T=Text, N=NumberValues, O=OptionList, F=FileButton, C=CheckBox
widget = ("T","T","N","N","N")

#---parameter of the module---
labels    = ("", "", "X offset", "Y offset", "Z offset")

#---option presets for listed parameters---
options   = {}



class module( object ):
    #############################################################################
    #                                                                           #
    #    02.00 g-code generator                                                 #
    #                                                                           #
    #############################################################################
    def gcode( self, jTools, joblist, jIndex, preview=0 ):
        global name
        L = uni.language 
        
        #########################################################################
        #    02.01 local vars                                                   #
        #########################################################################

        #---extrace name, tool and param rows from joblist table---
        jNames = [job[1] for job in joblist]
        jParams = [job[2:] for job in joblist] #for contents, see labels
        
        #---variable values---
        if name in uni.language: LName = uni.language[name]
        else: LName = name
        code          = "\n(" + ("-"*30) + LName + jNames[jIndex][-4:] + ("-"*30) + ")\n\n"
        x0            = jParams[jIndex][0]
        y0            = jParams[jIndex][1]
        x             = jParams[jIndex][2]
        y             = jParams[jIndex][3]
        z             = jParams[jIndex][4]
        

        #########################################################################
        #    02.02 change values by options                                     #
        #########################################################################


        #########################################################################
        #    02.03 startcodes                                                   #
        #########################################################################

                     
        #########################################################################
        #    02.05 g-code generation for module                                 #
        #########################################################################

        #---move to position---
                
        code += "G10 L2 P0 X{:.0f} Y{:.0f} Z{:.0f}\n\n".format( x,y,z )
        

        #########################################################################
        #    02.05 end codes                                                    #
        #########################################################################
        
        return code 
   

   
    #############################################################################
    #                                                                           #
    #    03.00 determine start-/endtool                                         #
    #                                                                           #
    #############################################################################
    # function returns start/endtool of THIS module for toolOptimizer 
    # "" will be ignored by optimizer 
    # "nT" will force to load no Tool
    def tool( self, joblist, jIndex ):
        
        return ("","") #(Start, Endtool)
