#################################################################################
#                                                                               #
#    Translation File - English                                                 #
#                                                                               #
#################################################################################
# Copyright 2020 Kai Masemann                                                   #
#################################################################################
# This file is part of Lonnox CUT                                               #
#                                                                               #
#   Lonnox CUT is free software: you can redistribute it and/or modify          #
#   it under the terms of the GNU General Public License as published by        #
#   the Free Software Foundation, either version 3 of the License, or           #
#   (at your option) any later version.                                         #
#                                                                               #
#   Lonnox CUT is distributed in the hope that it will be useful,               #
#   but WITHOUT ANY WARRANTY; without even the implied warranty of              #
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               #
#   GNU General Public License for more details.                                #
#                                                                               #
#   You should have received a copy of the GNU General Public License           #
#   along with Lonnox CUT.  If not, see <http://www.gnu.org/licenses/>.         #
#                                                                               #
#################################################################################

language = {
    '(Cancel radius compensation)\n' : '(Cancel radius compensation)\n' ,
    '(Curve tolerance in mm)\n' : '(Curve tolerance in mm)\n' ,
    '(Dimensionvalues in mm)\n' : '(Dimensionvalues in mm)\n' ,
    '(Put down left limit stops)\n\n' : '(Put down left limit stops)\n\n' ,
    '(Put down right limit stops)\n\n' : '(Put down right limit stops)\n\n' ,
    '(Reset coordinate system)' : '(Reset coordinate system)' ,
    '(Speedvalues in mm/Min)\n' : '(Speedvalues in mm/Min)\n' ,
    '(Tool activate)\n' : '(Tool activate)\n' ,
    '(Tool deactivate)\n' : '(Tool deactivate)\n' ,
    '(Use absolute coordinates)\n' : '(Use absolute coordinates)' ,
    '(Wait for left vacuum and limit stops)\n' : '(Wait for left vacuum and limit stops)\n' ,
    '(Wait for right vacuum and limit stops)\n' : '(Wait for right vacuum and limit stops)\n' ,
    'Abort' : 'Abort',
    'About Lonnox CUT' : 'About Lonnox CUT' ,
    'About Lonnox CUT and licence' : 'About Lonnox CUT and licence' ,
    'Add job to joblist -->' : 'Add job to joblist -->' ,
    'Add modules...' : 'Add modules...' ,
    'Add new modules from zip file to Lonnox CUT' : 'Add new modules from zip file to Lonnox CUT' ,
    'All' : 'All',
    'Angle' : 'Angle' ,
    'Apply parameter -->' : 'Apply parameter -->' ,
    'Ballnose' : 'Ballnose' ,
    'Bow' : 'Bow' ,
    'Bow radius' : 'Bow radius' ,
    'Bow radius is to small/ font is to big!' : 'Bow radius is to small/ font is to big!' ,
    'Calculating preview (ESC);' : 'Calculating preview (ESC);' ,
    'Calculating textpath (ESC)...' : 'Calculating textpath (ESC)...' ,
    'Center' : 'Center' ,
    'Choose a dxf filter:' : 'Choose a dxf filter:',
    'Choose file' : 'Choose file' ,
    'Circle' : 'Circle' ,
    'Climb milling' : 'Climb milling' ,
    'Close' : 'Close' ,
    'Configfolder' : 'Configfolder' ,
    'Contour Type' : 'Contour Type' ,
    'Contour-End' : 'Contour-End' ,
    'Contour-Group' : 'Contour-Group' ,
    'Contour-List' : 'Contour-List' ,
    'Contour-Point' : 'Contour-Point' ,
    'Control Points' : 'Control Points',
    'Coordinate system' : 'Coordinate system' ,
    'Cutdepth' : 'Cutdepth' ,
    'Cutpath' : 'Cutpath' ,
    'Default' : 'Default' ,
    'Delete joblist' : 'Delete joblist' ,
    'Delete selected Jobs' : 'Delete selected Jobs' ,
    'Depth' : 'Depth' ,
    'Depth of middlehole' : 'Depth of middlehole' ,
    'Details for selected module' : 'Details for selected module' ,
    'Diameter' : 'Diameter' ,
    'Direction' : 'Direction' ,
    'Disable' : 'Disable' ,
    'Doortape' : 'Doortape' ,
    'Down' : 'Down' ,
    'Drill' : 'Drill' ,
    'Drill bit' : 'Drill bit' ,
    'Drill direction' : 'Drill direction' ,
    'Edge front' : 'Edge front',
    'Edge back' : 'Edge back',
    'Edge right' : 'Edge right',
    'Edge left' : 'Edge left',
    'Ellipse' : 'Ellipse' ,
    'Enable' : 'Enable' ,
    'Enable/disable selected jobs' : 'Enable/disable selected jobs' ,
    'Endangle' : 'Endangle' ,
    'Endmill' : 'Endmill' ,
    'Facing' : 'Facing' ,
    'Feed' : 'Feed' ,
    'File' : 'File' ,
    'Finalposition\nspeed' : 'Finalposition\nspeed' ,
    'Finalposition X' : 'Finalposition X' ,
    'Finalposition Y' : 'Finalposition Y' ,
    'Finish' : 'Finish' ,
    'Fit Points' : 'Fit Points',
    'Fontfile' : 'Fontfile' ,
    'Foot' : 'Foot' ,
    'Format' : 'Format' ,
    'General' : 'General' ,
    'Generate and save gcode from the joblist' : 'Generate and save gcode from the joblist' ,
    'Graver' : 'Graver' ,
    'Groovesaw' : 'Groovesaw' ,
    'Groovesaw X' : 'Groovesaw X' ,
    'Groovesaw Y' : 'Groovesaw Y' ,
    'Guide holes' : 'Guide holes',
    'Height (b)' : 'Height (b)' ,
    'Help' : 'Help' ,
    'High' : 'High',
    'HoleGrid' : 'HoleGrid' ,
    'HoleLine-3mm' : 'HoleLine-3mm' ,
    'HoleLine-5mm' : 'HoleLine-5mm' ,
    'HoleLine-Shelf' : 'HoleLine-Shelf' ,
    'Holeline\nBit amount' : 'Holeline\nBit amount' ,
    'Horizontal drill bit' : 'Horizontal drill bit' ,
    'HorizontalDowel' : 'HorizontalDowel' ,
    'HorizontalDrill' : 'HorizontalDrill' ,
    'HorizontalDrill-Y' : 'HorizontalDrill-Y' ,
    'Import dxf file...' : 'Import dxf file...',
    'Incompatibel Modul/Machine' : 'Incompatibel Modul/Machine' ,
    'Info' : 'Info' ,
    'Insert a copy of the selected jobs' : 'Insert a copy of the selected jobs' ,
    'Inside' : 'Inside' ,
    'Interpolation-Quality' : 'Interpolation-Quality' ,
    'Invalid tool for facing' : 'Invalid tool for facing' ,
    'Jobs' : 'Jobs' ,
    'Language\n(Restart)' : 'Language\n(Restart)' ,
    'Laser' : 'Laser' ,
    'Last segment' : 'Last segment' ,
    'Left' : 'Left' ,
    'Length' : 'Length',
    'Letterdistance' : 'Letterdistance' ,
    'Light version limits;' : 'Light version limits;' ,
    'Line' : 'Line' ,
    'List' : 'List', 
    'Load parameters of the selected job for editing' : 'Load parameters of the selected job for editing' ,
    'LockCase' : 'LockCase' ,
    'Lonnox CUT and joblist settings' : 'Lonnox CUT and joblist settings' ,
    'Loops' : 'Loops' ,
    'Low' : 'Low', 
    'Manual tool' : 'Manual tool' ,
    'Mark' : 'Mark' ,
    'Material' : 'Material',
    'Medium' : 'Medium',
    'Mill 2D' : 'Mill 2D' ,
    'Milling' : 'Milling',
    'Mirror' : 'Mirror' ,
    'Mirror selected jobs' : 'Mirror selected jobs' ,
    'Module specific parameter' : 'Module specific parameter' ,
    'Modules' : 'Modules' ,
    'Move selected jobs down' : 'Move selected jobs down' ,
    'Move selected jobs on x axis' : 'Move selected jobs on x axis' ,
    'Move selected jobs on y axis' : 'Move selected jobs on y axis' ,
    'Move selected jobs up' : 'Move selected jobs up' ,
    'Name' : 'Name' ,
    'New' : 'New' ,
    'New joblist' : 'New joblist' ,
    'No' : 'No' ,
    'Normal' : 'Normal' ,
    'Off' : 'Off' ,
    'On' : 'On' ,
    'Open' : 'Open' ,
    'Open file' : 'Open file' ,
    'Open joblist file' : 'Open joblist file' ,
    'Open the folder with config data' : 'Open the folder with config data' ,
    'Options' : 'Options' ,
    'Orientation' : 'Orientation' ,
    'Other' : 'Other' ,
    'Outside' : 'Outside' ,
    'Overlap in %' : 'Overlap in %' ,
    'Part info' : 'Part info',
    'Pause' : 'Pause' ,
    'Picture-Tracer' : 'Picture-Tracer' ,
    'Picturefile' : 'Picturefile' ,
    'Plunge feed\nin %' : 'Plunge feed\nin %' ,
    'Plunge feed' : 'Plunge feed' ,
    'Pocket - Circle' : 'Pocket - Circle' ,
    'Pocket - Rectangle' : 'Pocket - Rectangle' ,
    'Point' : 'Point' ,
    'Point Type' : 'Point Type',
    'Position' : 'Position' ,
    'Preview\nrotation' : 'Preview\nrotation' ,
    'Quality' : 'Quality',
    'Quit' : 'Quit' ,
    'Radius (r)' : 'Radius (r)' ,
    'Raw' : 'Raw' ,
    'Rawpart' : 'Rawpart' ,
    'Save changes?' : 'Save changes?' ,
    'Rectangle' : 'Rectangle' ,
    'Remove margin' : 'Remove margin' ,
    'Repeat-End' : 'Repeat-End' ,
    'Repeat-Group' : 'Repeat-Group' ,
    'Right' : 'Right' ,
    'Rotation' : 'Rotation' ,
    'Save' : 'Save' ,
    'Save as...' : 'Save as...' ,
    'Save gcode file' : 'Save gcode file' ,
    'Save joblist file' : 'Save joblist file' ,
    'Save joblist with new name' : 'Save joblist with new name' ,
    'Save workspace and quit Lonnox CUT' : 'Save workspace and quit Lonnox CUT' ,
    'Saw' : 'Saw' ,
    'Saw blade thickness' : 'Saw blade thickness' ,
    'Scale' : 'Scale' ,
    'Settings' : 'Settings' ,
    'Show/Hide G0 Path' : 'Show/Hide G0 Path' ,
    'Shows GCode drawings preview' : 'Shows GCode drawings preview' ,
    'Shows GCode text preview' : 'Shows GCode text preview' ,
    'Shows module pictures' : 'Shows module pictures' ,
    'Side' : 'Side' ,
    'Size in mm' : 'Size in mm' ,
    'Sleep' : 'Sleep' ,
    'Spline-End' : 'Spline-End',
    'Spline-Group' : 'Spline-Group',
    'Spline-Point' : 'Spline-Point',
    'Spline Type' : 'Spline Type',
    'Startangle' : 'Startangle' ,
    'Stops' : 'Stops' ,
    'Thickness' : 'Thickness' ,
    'This module use a predefined Tool' : 'This module use a predefined Tool' ,
    'Time in seconds' : 'Time in seconds' ,
    'Tool' : 'Tool' ,
    'Tool - manual' : 'Tool - manual' ,
    'Tool length (Z Abs)' : 'Tool length (Z Abs)' ,
    'Toolchange' : 'Toolchange' ,
    'TrueType-Text' : 'TrueType-Text' ,
    'TrueType-Text-Bow' : 'TrueType-Text-Bow' ,
    'Two side\nworking' : 'Two side\nworking' ,
    'Type' : 'Type' ,
    'Unknown platform/filemanager' : 'Unknown platform/filemanager' ,
    'Up' : 'Up' ,
    'Up-cut milling' : 'Up-cut milling' ,
    'Upgrade To Lonnox CUT Pro...' : 'Upgrade To Lonnox CUT Pro...' ,
    'Upgrade to Pro Version of Lonnox CUT with a license file' : 'Upgrade to Pro Version of Lonnox CUT with a license file' ,
    'Used Area;' : 'Used Area;' ,
    'Validation' : 'Validation' ,
    'Value' : 'Value' ,
    'Variable' : 'Variable' ,
    'VerticalDrill' : 'VerticalDrill' ,
    'Weight' : 'Weight' ,
    'Width' : 'Width',
    'Width (a)' : 'Width (a)' ,
    'X Y Mode' : 'X Y Mode' ,
    'X maximum' : 'X maximum' ,
    'X negative' : 'X negative' ,
    'X offset' : 'X offset' ,
    'X positive' : 'X positive' ,
    '(XY plane)\n' : '(XY plane)\n',
    'X/Y Offset to format stop-edges of workpeace [mm];' : 'X/Y Offset to format stop-edges of workpeace [mm];' ,
    'Y invert' : 'Y invert' ,
    'Y maximum' : 'Y maximum' ,
    'Y negative' : 'Y negative' ,
    'Y offset' : 'Y offset' ,
    'Y positive' : 'Y positive' ,
    'Ya Depth' : 'Ya Depth' ,
    'Yes' : 'Yes' ,
    'Z maximum' : 'Z maximum' ,
    'Z offset' : 'Z offset' ,
    'Z save height' : 'Z save height' ,
    'Zero Point X' : 'Zero Point X' ,
    'Zero Point Y' : 'Zero Point Y' ,
    }

    
infos = {
    "LineInfo" :       ("G E N E R A L\n"
                        "  This module is used to cut a straight line. \n\n"
                        "F E E D\n"
                        "  The forward feed should have a value between 500 and 8000 mm/min."),
    "RawInfo" :        ("G E N E R A L\n"
                        "  The module defines the rawpart dimensions.\n\n"
                        "M A T E R I A L    T H I C K N E S S\n"
                        "  The 'Thickness' value is used for the depth calculation. If no\n"
                        "  Rawpart is defined, a touch probe to the upper side of the\n"
                        "  workpeace should be used."),                  
    "MarkInfo" :       ("G E N E R A L\n"
                        "  This module marks a given position with a tool like a laser. \n"
                        "  The module uses a fast move with G0."),
    "ToolchangeInfo" : ("G E N E R A L\n"
                        "  This module defines the tool for every following module.\n"
                        "  If there is a module with predefined tools in between the following\n"
                        "  modules, the predefined tools will be used temporarily.\n\n"),
    "ToolchangeMInfo" :("G E N E R A L\n"
                        "  This module defines the tool for every following module.\n"
                        "  If there is a module with predefined tools in between the following\n"
                        "  modules, the predefined tools will be used temporarily.\n\n"
                        "A C T I V A T I O N / D E A C T I V A T I O N\n"
                        "  Here the GCode Text for activation / deaktivation of the\n"
                        "  tool is needed, for example M3 / M5.\n\n"
                        "T O O L   L E N G T H\n"
                        "  Here the absolute position of the Z axis is needed, while\n"
                        "  the tool touches the workbench (Vakuumtable).\n\n"),
    "EllipseInfo" :    ("G E N E R A L\n"
                        "  This module cuts an ellipse. Because of performance-reasons, the\n" 
                        "  quality in the preview will be lower than in gcode. \n\n"
                        "F E E D\n"
                        "  The forward feed should be between 500 and 8000 mm/min.\n"
                        "L A S T    S E G M E N T\n" 
                        "  The option 'Last segment' offers the possibility to choose the last\n"
                        "  part of the milling process. This method minimize a lift of the\n"
                        "  cuttings and is therefore usefull to prevent collisions."),    
    "BowInfo" :        ("G E N E R A L\n"
                        "  This module cuts a bow from start- to endangle in clockwise\n" 
                        "  direction.\n\n"
                        "F E E D\n"
                        "  The forward feed should have a value between 500 and 8000 mm/min.\n\n"
                        "A N G L E\n" 
                        "  Negative start and endangles are recalculated to positive values\n"
                        "  (-5.00° --> +355°).\n\n"),
    "CircleInfo" :     ("G E N E R A L\n"
                        "  This module cuts our a full circle. \n\n"
                        "F E E D\n"
                        "  The plunge feed is 30% of the feed value. \n"
                        "  The forward feed should have a value between 500 and 8000 mm/min.\n\n"
                        "L A S T    S E G M E N T\n" 
                        "  The option 'Last segment' offers the possibility to choose the last\n"
                        "  part of the milling process. This method minimize a lift of the\n"
                        "  cuttings and is therefore usefull to prevent collisions."),    
    "ContourGInfo" :   ("G E N E R A L\n"
                        "  This module is the basemodul for creating contour drawings with\n"
                        "  contourpoints. The parameter of this module are assigned to every\n"
                        "  contourpoint that immediately follows. \n"
                        "  Every contour needs a 'Contour-Group' at least 2 'Contour-Points'\n"
                        "  and a 'Contor-End'. \n\n"
                        "F E E D\n"
                        "  The forward feed should have a value between 500 and 8000 mm/min."),
    "ContourLInfo" :   ("G E N E R A L\n"
                        "  This module can be used to create contours with a list of values,that\n"
                        "  are seperated by a semicolon.\n"
                        "  Contour-List must be listed below a'Contour-Group'.\n\n"
                        "R A D I U S\n" 
                        "  The radius parameter is used for a tangential rounding between two.\n"
                        "  lines.\n\n"),
    "ContourPInfo" :   ("G E N E R A L\n"
                        "  This module offers the possibility to create contours. In the Joblist\n"
                        "  Contour-Points must immediately be listed below a'Contour-Group'.\n\n"
                        "R A D I U S\n" 
                        "  The radius parameter is used for a tangential rounding between two.\n"
                        "  lines.\n\n"
                        "F E E D\n"
                        "  The forward feed should have a value between 500 and 8000 mm/min."),
    "CoordSysInfo" :   ("G E N E R A L\n"
                        "  This module sets the offset of the coordinate-systems by using G10.\n"
                        "  If X,Y,Z = 0 the coordinate-system is reset and every offset will\n"
                        "  be canceled.\n\n"
                        "T O O L C H A N G E\n" 
                        "  The Module also reset the toollength, so it is recommended to\n"
                        "  insert it only directly before toolchanges."),
    "DoortapeInfo" :  ("G E N E R A L\n"
                        "  The module can be used to make holes for doortapes. The holes are\n"
                        "  drilled in one step to reach the given depth.\n\n"
                        "O P T I O N A L    P A R A M E T E R\n" 
                        "  Only holes that have a X value greater than 0 are drilled."),
    "DowelhInfo" :     ("G E N E R A L\n"
                        "  This module is used to create the holes for quick-connectors\n"
                        "  and dowels.\n"
                        "  The holes that are deeper than 18mm are drilled in several step to\n"
                        "  reach the given depth.\n\n"
                        "O P T I O N A L    P A R A M E T E R\n" 
                        "  Only holes that have a Y value greater than 0 are drilled."),
    "VDrillInfo" :     ("G E N E R A L\n"
                        "  This module is used to create vertical drills.\n\n"
                        "F E E D\n"
                        "  The forward feed should have a value between 1000 and 4000 mm/min.\n"),                        
    "FacingInfo" :     ("G E N E R A L\n"
                        "  This module can be used to create a flat surface or to create a.\n"
                        "  simple pocket.\n\n"
                        "F E E D\n"
                        "  The forward feed should have a value between 500 and 8000 mm/min."),
    "FootInfo" :       ("G E N E R A L\n"
                        "  This module creates holes to fix cabinet foots.\n\n"
                        "D E P T H\n"
                        "  Holes with a depth of more than 15mm will be drilled in 15mm steps."),
    "FormatInfo" :     ("G E N E R A L\n"
                        "  This module creates a precise rectangle.\n\n"
                        "F E E D\n"
                        "  The forward feed should have a value between 5000 and 12000 mm/min."),
    "GroovesawXInfo" : ("G E N E R A L\n"
                        "  This module creates a groove with a groovesaw.\n\n"
                        "D E P T H\n"
                        "  Holes with a depth of more than 20mm will be cut in 20mm steps.\n\n"
                        "F E E D\n"
                        "  The forward feed should have a value between 5000 and 15000 mm/min."),
    "HDrillXInfo" :    ("G E N E R A L\n"
                        "  This module can be used to drill horizontal holes.\n\n"
                        "D E P T H\n"
                        "  Holes with a depth of more than 15mm will be drilled in 15mm steps.\n\n"
                        "F E E D\n"
                        "  The plunge feed should have a value between 1000 and 4000 mm/min."),
    "HoleGridInfo" :   ("G E N E R A L\n"
                        "  This module creates a grid of holes.\n\n"
                        "F E E D\n"
                        "  The plunge feed should have a value between 1000 and 4000 mm/min."),
    "HLInfo5mm" :      ("G E N E R A L\n"
                        "  This module is used to create holelines with a 3 x 5mm tool in a.\n"
                        "  32mm grid. The Xb value must not point exactly to the last hole. \n\n"
                        "O P T I O N A L    P A R A M E T E R\n" 
                        "  Only holes that have a Y value greater than 0 are drilled.\n\n"
                        "D E P T H\n"
                        "  Holes with a depth of more than 15mm will be drilled in 15mm steps."),
    "HLShelfInfo" :    ("G E N E R A L\n"
                        "  This module is used to create hole lines for shelves.\n\n"
                        "O P T I O N A L    P A R A M E T E R\n" 
                        "  Only x and Y values greater than 0 are used.\n\n"
                        "F E E D\n"
                        "  The forward feed should have a value between 1000 and 4000 mm/min."),
    "PositionInfo" :   ("G E N E R A L\n"
                        "  This module is used to move to a specified position.\n"
                        "  The movement is executed rapidly with G0."),
    "RectangleInfo" :  ("G E N E R A L\n"
                        "  This module creates a rectangel with optional roundings.\n\n"
                        "L A S T    S E G M E N T\n" 
                        "  The option 'Last segment' offers the possibility to choose the last\n"
                        "  part of the milling process. This method minimize a lift of the\n"
                        "  cuttings and is therefore usefull to prevent collisions.\n\n"    
                        "F E E D\n"
                        "  The forward feed should have a value between 500 and 8000 mm/min."),
    "RotationInfo"  :  ("G E N E R A L\n"
                        "  This module is used to rotate the following modules that are rotatable.\n"
                        "  The rotated modules are moved in dependence of the Rawpart, therefore\n"
                        "  the Rotate Modul must be insertet before the Rawpart.\n\n"),
    "SplineEInfo" :    ("G E N E R A L\n"
                        "  This module is used to complete a 'Spline-Group'.\n\n"),
    "SplineGInfo" :    ("G E N E R A L\n"
                        "  This module is the basemodul for creating spline drawings with\n"
                        "  splinepoints. The parameter of this module are assigned to every\n"
                        "  splinepoint that immediately follows. \n"
                        "  Every spline needs a 'Spline-Group' at least 3 'Spline-Points'\n"
                        "  and a 'Spline-End'. \n\n"),
    "SplinePInfo" :    ("G E N E R A L\n"
                        "  This module offers the possibility to create splines. In the Joblist\n"
                        "  Spline-Points must immediately be listed below a'Spline-Group'.\n\n"
                        "  The weight value describes the influence of the point to the curve.\n"
                        "  Standard value is 1.0, to ignore the parameter set it to 0.0 ."),
    "StopsInfo" :      ("G E N E R A L\n"
                        "  The module raise/sink the stop edges of the machine."),
    "TextInfo" :       ("G E N E R A L\n"
                        "  This module can be used to cut out TrueType fonts.\n"
                        "  TrueType fonts can be downloaded from www.dafont.com\n\n"
                        "I N T E R P O L A T I O N\n"
                        "  The 'interpolation quality' defines the precision of curve-calculations.\n" 
                        "  The value should be between 2 and 20 depending on the font, desired\n"
                        "  result and computing power. The quality differences are shown in the\n"
                        "  drawing preview.\n\n"
                        "C U T P A T H\n"
                        "  The quality of the 'cutpath' options depends on the font quality\n"
                        "  and the cutter diameter.\n\n"
                        "F E E D\n"
                        "  The forward feed should have a value between 500 and 8000 mm/min."),
     "ContourEInfo" :  ("G E N E R A L\n"
                        "  This module is used to complete a 'Contour-Group'.\n\n"),
     "RepeatInfo" :    ("G E N E R A L\n"
                        "  This module can be used to repeat the modules that immediately follows\n"
                        "  this module in the joblist.\n"
                        "  To complete a 'Repeat-Group' a 'Repeat-End' module must be added."),
     "RepeatEInfo" :   ("G E N E R A L\n"
                        "  This module is used to complete a 'Repeat-Group'."),
     "ValidationInfo" :("G E N E R A L\n"
                        "  This module waits for for the right state of the stops and the vacuum\n"
                        "  to continue the gcode program."),
     "PauseInfo" :     ("G E N E R A L\n"
                        "  the module waits until the play button is pushed."),
     "SleepInfo" :     ("G E N E R A L\n"
                        "  The module waits until the given time has expired."),
     "TracerInfo" :    ("G E N E R A L\n"
                        "  The modul converts pixel pictures to vector pictures. For best\n"
                        "  Results use pictures with not more than 2 colors (b/w). You can use\n" 
                        "  different picture formats for example gif, jpg, png, bmp, e.t.c.\n\n"
                        "  Hint: By using PhotoShop or Gimp2 (free) you can create and edit\n"
                        "  pictures to partly replace a CAD program.\n\n"
                        "  Details: To conversion is done with the software Potrace which\n"
                        "  uses a highly developed algorithm for cubic spline calculation."),
     "VariableInfo" :  ("G E N E R A L\n"
                        "  Variables are values that can be used inside of module parameters.\n"
                        "  This makes it possible to change values like 'length' or 'width'\n"
                        "  simply for multiple modules.\n"
                        "  Variables can be inserted to parameter fields by its name and can\n"
                        "  be part of calculations.\n"
                        "  Example: '500 + width'\n\n"
                        "  It is not possible to use calculations inside the value field of\n"
                        "  the variable module.")
   }        

